/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.actionControllers;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.configurations.processor.IConfigurationProcessor;
import com.aptana.configurations.processor.IConfigurationProcessorListener;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.BrowserNotifier;
import com.aptana.portal.ui.dispatch.IBrowserNotificationConstants;
import com.aptana.portal.ui.dispatch.actionControllers.AbstractActionController;
import com.aptana.portal.ui.dispatch.actionControllers.ControllerAction;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudioUpdateController
extends AbstractActionController {
    @ControllerAction
    public Object checkForUpdate() {
        final IConfigurationProcessor processor = this.getProcessor(true);
        if (processor != null) {
            Job computationJob = new Job("Checking for a Studio update..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        processor.addConfigurationProcessorListener((IConfigurationProcessorListener)StudioUpdateController.this);
                        ConfigurationStatus status = processor.getStatus(monitor, null, true);
                        if (status.getStatus() != "ok") {
                            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Error while checking for Studio updates");
                        }
                    }
                    finally {
                        processor.removeConfigurationProcessorListener((IConfigurationProcessorListener)StudioUpdateController.this);
                    }
                    return Status.OK_STATUS;
                }
            };
            EclipseUtil.setSystemForJob((Job)computationJob);
            computationJob.schedule();
            return IBrowserNotificationConstants.JSON_OK;
        }
        IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Missing processor for the StudioUpdateController");
        return IBrowserNotificationConstants.JSON_OK;
    }

    @ControllerAction
    public Object installUpdate() {
        final IConfigurationProcessor processor = this.getProcessor(true);
        if (processor != null) {
            Job computationJob = new Job("Installing a Studio update..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        processor.addConfigurationProcessorListener((IConfigurationProcessorListener)StudioUpdateController.this);
                        ConfigurationStatus status = processor.configure(monitor, null);
                        if (status.getStatus() != "ok") {
                            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Error while installing a Studio update");
                        }
                    }
                    finally {
                        processor.removeConfigurationProcessorListener((IConfigurationProcessorListener)StudioUpdateController.this);
                    }
                    return Status.OK_STATUS;
                }
            };
            EclipseUtil.setSystemForJob((Job)computationJob);
            computationJob.schedule();
            return IBrowserNotificationConstants.JSON_OK;
        }
        IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Missing processor for the StudioUpdateController");
        return IBrowserNotificationConstants.JSON_ERROR;
    }

    public void configurationStateChanged(ConfigurationStatus status, Set<String> attributesChanged) {
        if (attributesChanged != null && attributesChanged.contains("status")) {
            List<String> emptyList = Collections.emptyList();
            BrowserNotifier.getInstance().notifyBrowserInUIThread(emptyList, "studioUpdate", "response", JSON.toString((Object)status));
        }
    }
}

